#include <iostream>
#include <vector>
#include <string>
#include <cmath>
using namespace std;


bool operation(char c){
    return c=='+' || c=='*' ;
}


int prioritet(char op){
    if(op<0) return 3;
    else{
        if(op == '+')return 1;
        else if(op == '*')return 2;
        else return -1;
    }
}


void action(vector<long> &value, char op){
    if(op<0){
        long unitar=value.back();
        value.pop_back();
    }
    else{
        long right = value.back();
        value.pop_back();
        long left = value.back();
        value.pop_back();
        if(op=='+')value.push_back(left+right);
        else if(op=='*')value.push_back(left*right);
    }
}

long calculator(string &formula){
    bool unary=true;
    vector<long>value;
    vector<char>op;
    for(int i=0; i<formula.size(); i++){
            if(formula[i]=='('){
                op.push_back('(');
                unary=true;
            }
            else if(formula[i]==')'){
                while(op.back()!='('){
                    action(value, op.back());
                    op.pop_back();
                }
                op.pop_back();
                unary=false;
            }
            else if(operation(formula[i])){
                char zn=formula[i];
                if(unary==true)zn=-zn;
                while(!op.empty() && prioritet(op.back())>=prioritet(zn)){
                    action(value, op.back());
                    op.pop_back();
                }
                op.push_back(zn);
                unary=true;
            }
            else{
                string number;
                while(i<formula.size() && isdigit(formula[i]))number+=formula[i++];
                i--;
                value.push_back(atol(number.c_str()));
                unary=false;
            }
        }
    while(!op.empty()){
        action(value, op.back());
        op.pop_back();
    }
    return value.back();
}
    
int main() {
    string formula;
    cin>>formula;

    cout<<calculator(formula);
    return 0;
}
